#ifndef __SERIAL_USB_H
#define __SERIAL_USB_H

/* 
	Abstract Serial Channel Over USB, 
	by Mauro Grassi, October 2010.
	
	Presents a serial pipe over USB transport.
	Useful for diagnostics and debugging 
	without a serial port...
	
*/

#define 		MAX_SERIAL_PIPE_LENGTH	120
#define         SERIAL_PIPE_OK			0x00
#define			SERIAL_PIPE_OVERFLOW	0x01
#define         SERIAL_PIPE_UNDERFLOW   0x02  

void 			flushSerialUSB(void);
unsigned char 	disFixSerialUSB(unsigned char x);
void 			disASerialUSB(unsigned char x);
void 			disWSerialUSB(unsigned int x);
void 			disDWSerialUSB(unsigned long x);
void 			disDecSerialUSB(unsigned int x);
void 			sendCharSerialUSB(unsigned char c);
void 			sendRamStringSerialUSB(unsigned char* ramString);
void 			sendRomStringSerialUSB(unsigned const rom char* romString);
void 			initSerialUSB(void);

extern unsigned char 	serialPipe[MAX_SERIAL_PIPE_LENGTH];
extern unsigned char    serialPipePutPtr;
extern unsigned char 	serialPipeGetPtr;
extern unsigned char 	serialPipeStatus;

#endif
